# S02009 {#s02009}

## Error Code {#error_code .section}

S02009

## Error Message {#error_message .section}

`Direct access using column names is not supported to retrieve data from a stream table. Please use a SQL query instead. RefId:S02009`

## Probable Causes {#probable_causes .section}

Stream tables store and publish streaming data and support concurrent read and write. Therefore, direct access to stream tables using member variable is not allowed. This error occurs when attempting to access a stream table using column names.

For example:

``` {#codeblock_uhf_rs5_1bc}
id=`XOM`GS`AAPL
rt=streamTable(id);
rt.id
```

## Solutions {#solutions .section}

Use a complete SQL statement to query a stream table.

``` {#codeblock_bjz_rs5_1bc}
rt.id
==> select id from rt
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

