# S02007 {#s02007}

## Error Code {#error_code .section}

S02007

## Error Message {#error_message .section}

`Direct access using column names is not supported to retrieve data from an MVCC table. Please use a SQL query instead. RefId:S02007`

## Probable Causes {#probable_causes .section}

MVCC tables employ concurrency control to enable secure and concurrent read and write. Therefore, direct access to MVCC tables using member variable is not allowed. This error occurs when attempting to access an MVCC table using column names.

For example:

``` {#codeblock_rgn_hs5_1bc}
id = `XOM`GS`AAPL
x = 102.1 33.4 73.6
t = mvccTable(id, x);

t.id
```

## Solutions {#solutions .section}

Use a complete SQL statement to query an MVCC table.

``` {#codeblock_n4l_3s5_1bc}
t.id
==> select id from t
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

