# S02005 {#s02005}

## Error Code {#error_code .section}

S02005

## Error Message {#error_message .section}

`Unrecognized column name. RefId:S02005`

## Probable Causes {#probable_causes .section}

This error may occur when the column specified in the SELECT statement does not exist in the referenced table. For example, the "x" column to be queried does not exist in table "t".

``` {#codeblock_xpf_xr5_1bc}
n = 10000
type = take(1..10, n)
sys = take(char('A' + 0..3), n)
t = table(type, sys)
select x from t; // throw an exception
select sys from t; // successfully executed
```

## Solutions {#solutions .section}

Verify that the column name used in the SELECT statement actually exists in the table being queried. Double-check for any typos or incorrect column names that may have been specified in the query.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

