# S02004 {#s02004}

## Error Code {#error_code .section}

S02004

## Error Message {#error_message .section}

`No partition returned by the sql object. RefId:S02004`

## Probable Causes {#probable_causes .section}

The data source generated by the parameter *sql* in the `loadTableBySQL` function is empty. For example:

``` {#codeblock_mz1_tr5_1bc}
n = 1000
t = table(rand('A'..'Z', n) as sym, 2000.01.01+rand(365, n) as date)

if (existsDatabase("dfs://tradeDB")) {
    dropDatabase("dfs://tradeDB")
}

db = database("dfs://tradeDB", VALUE, 'A'..'Z')
trades = db.createPartitionedTable(t,`trades,`sym).append!(t)

sample = select * from loadTableBySQL(<select * from trades where sym > 'Z'>)
```

## Solutions {#solutions .section}

Ensure that the data source returned by the *sql* parameter in the `loadTableBySQL` function has at least one partition.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

