# S02002 {#s02002}

## Error Code {#error_code .section}

S02002

## Error Message {#error_message .section}

`Failed to parse the metacode of SQL statement into distributed queries. RefId:S02002`

## Probable Causes {#probable_causes .section}

If the metacode of SQL statements involves distributed query, it will first check whether the query can be split into multiple subqueries for each partition. Queries below may throw an error:

1.  Queries that need a final unified operation after executing subqueries, such as a TOP N operation, may need to fetch a larger number of rows from each partition, and then perform a final TOP N merge.

    ``` {#codeblock_ify_yq5_1bc}
    SELECT EventTime FROM pt ORDER BY EventTime LIMIE 10;         
    ```

2.  Queries whose results depend on the data order, like calculating the difference between two adjacent elements \(function [deltas](../../Functions/d/deltas.md)\).

    ``` {#codeblock_cdh_dr5_1bc}
    SELECT deltas(x) FROM pt;
    ```

3.  Queries contain joins between different data sources like in-memory and partitioned tables.

    ``` {#codeblock_lfy_yq5_1bc}
    SELECT SUM(x) FROM t1 LEFT JOIN pt2 ON t1.id = pt2.id     
    ```

4.  Queries with PIVOT BY clause.

    ``` {#codeblock_nfy_yq5_1bc}
    SELECT x FROM PIVOTE BY timestamp, sym;
    ```


## Solutions {#solutions .section}

Check whether the query can be split into multiple subqueries. If not, consider replacing the SQL metacode with a SQL statement. For example:

``` {#codeblock_img_3r5_1bc}
n = 10000
type = take(1..10, n)
t = table(type)
dbName = "dfs://test_db";
db = database(dbName, HASH, [INT, 2])
pt = db.createPartitionedTable(t, `pt, `type)
pt.append!(t)

saveText(<select top 100 * from pt>, "res.txt") // throw an exception
saveText(select top 100 * from pt, "res.txt") // successfully executed
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

