# S02001 {#s02001}

## Error Code {#error_code .section}

S02002

## Error Message {#error_message .section}

`Duplicate column name: <xxx>. RefId:S02001`

## Probable Causes {#probable_causes .section}

This error occurs when executing SQL statements with duplicate column names in SELECT column \(or GROUP BY column if has\). The probable causes may include:

1.  Duplicated names in SELECT statement, e.g.,`select id, id from a` or `select id, val as id from a`.

2.  Name duplicated with the implicit alias from functions, expressions, or analytic functions, e.g., `select id as sum, sum(id) over () from a`.

3.  Name duplicated with the implicit alias from the join results, e.g., `select a.id + 1 as b_id, * from a, b where a.id = b.id`.

4.  Name duplicated with the DolphinDB reserved column names: *col + numbers* \(e.g., "col1"\).


## Solutions {#solutions .section}

1.  Check the specified column names in SELECT statement or GROUP BY clause.

2.  Use the `as` keyword to rename the column.

3.  Avoid to use the DolphinDB reserved column names. You can use underscores as the prefix and suffix, e.g. "\_id\_" or use special symbols, e.g. "\{0\|V^^N3".


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

