# S02000 {#s02000}

## Error Code {#error_code .section}

S02000

## Error Message {#error_message .section}

`Columns specified in valueColNames of function unpivot must be of the same data type. RefId:S02000`

## Probable Causes {#probable_causes .section}

When using function `unpivot` to convert multiple columns specified in parameter *valueColNames* into a single column, it is required that the values in these columns must have the same data type.

For example, the following script will raise an error due to the specified columns in *valueColNames* having different data types: "col1" is of INT type, while "col2" is of STRING type.

``` {#codeblock_urk_lq5_1bc}
t=table(1..3 as id, 2010.01.01 + 1..3 as time, 4..6 as col1, `aaa`bbb`ccc as col2)
t.unpivot(keyColNames=`id, valueColNames=`col1`col2);
```

For more details on the `unpivot` function, see [unpivot](../../Functions/u/unpivot.md).

## Solutions {#solutions .section}

Check whether the columns specified by *valueColNames*parameter have the same data type.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

