# S01063 {#S01063}

## Error Code {#error_code .section}

S01063

## Error Message {#error_message .section}

`Failed to create rollback log file <xxx>: <errMsg>. RefId: S01063`

## Probable Causes {#probable_causes .section}

This error occurs when the server attempts to create a rollback log file during a transaction but fails.

## Solutions {#solutions .section}

Troubleshoot based on the error message. Common issues include:

<table id="table_cmh_j5d_lcc"><thead><tr><th>

**Error Message**

</th><th>

**Probable Causes**

</th><th>

**Solutions**

</th></tr></thead><tbody><tr><td>

Permission denied

</td><td>

Lack of write permissions for the directory where the log file is located.

</td><td>

Check the permissions of the server and grant it the write permissions for the directory.

</td></tr><tr><td>

Too many open files

</td><td>

The program has too many files open.

</td><td>

-   Check the number of open files using `lsof -p [process ID]|wc -l`.
-   Check the maximum number of open files using `ulimit -n`.
-   Increase the maximum number of open files using `ulimit -n 65535`.

 For more solutions, refer to [Too many open files](https://askubuntu.com/questions/1182021/too-many-open-files).

</td></tr><tr><td>

No space left on device

</td><td>

There is no space left on the disk.

</td><td>

Check if there is any space left on the disk. If not, free up some space.

</td></tr><tr><td>

Read-only file system

</td><td>

The file system is read-only.

</td><td>

Check if the file system has write permissions.

 For more solutions, refer to [How to fix "sudo: unable to open ... Read-only file system"?](https://askubuntu.com/questions/197459/how-to-fix-sudo-unable-to-open-read-only-file-system)

</td></tr></tbody>
</table>**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

