# S01047 {#S01047}

## Error Code {#error_code .section}

S01047

## Error Message {#error_message .section}

`Compaction blocked: Existing task in level <xxx>, chunk <cid>, table <xxx>. Only one compaction task is allowed. RefId: S01047`

## Probable Causes {#probable_causes .section}

This error occurs when the TSDB engine checks if the level 3 files in a chunk need to be compacted but there is already an ongoing compaction task at level 3 in the chunk. Note that TSDB only supports one compaction task at level 3 per chunk.

## Solutions {#solutions .section}

Use the [getTSDBCompactionTaskStatus](../../Functions/g/getTSDBCompactionTaskStatus.md) function to view the status of TSDB level file compaction tasks. Wait for the previous compaction task to complete before performing another.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

