# S01040 {#S01040}

## Error Code {#error_code .section}

S01040

## Error Message {#error_message .section}

`[asyncReplication] Skipped task <taskId>. Task data does not exist on site <IP:Port>. RefId: S01040`

## Probable Causes {#probable_causes .section}

The slave cluster for asynchronous replication attempts to access task data from the master cluster but finds that the task does not exist.

## Solutions {#solutions .section}

Execute the following command to check failed task status:

``` {#codeblock_wb4_pkz_zbc}
select * from rpc(getControllerAlias(),getSlaveReplicationStatus) where state = "FAILED"
```

If a task is marked "FAILED" with "Missing TaskData" shown in details, it does not exist in the master cluster. You can check whether *&lt;masterTid&gt;.task* file exists in the persistence directory \(which is configured with *clusterReplicationWorkDir* in file *cluster.cfg*\) of the master cluster.

-   If the file exists, restart the data node of the master cluster, and retry the tasks with `startClusterReplication`.

-   If the file does not exist, check if *clusterReplicationSyncPersistence* is set to true. When set to false, data of replication tasks may be lost. You may refer to the asynchronous replication logs, modify configurations, and skip this task.


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

