# S01025 {#s01025}

## Error Code {#error_code .section}

S01025

## Error Message {#error_message .section}

`The task with ID <taskId> on node <nodeAlias> is finished or invalid. RefId:S01025`

## Probable Causes {#probable_causes .section}

When cluster replication is enabled, the controller of the slave cluster may log this error. Possible reasons include:

-   The data node received multiple execution requests for a job due to network issues.
-   The data node on the slave cluster may have unexpectedly shut down and restarted.

The controller checks if a task has already completed every time a task execution request is received. If the task has already completed, this error is reported, and duplicate transaction will be rolled back to ensure the task is executed only once.

## Solutions {#solutions .section}

Use `rpc(getControllerAlias(), getSlaveReplicationStatus)` to check the task execution status.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

