# S01013 {#s01013}

## Error Code {#error_code .section}

S01013

## Error Message {#error_message .section}

`Failed to drop partition <xxx> because the replicas are currently unavailable. RefId:S01013`

## Probable Causes {#probable_causes .section}

When using the `dropPartition` function with *forceDelete* = false, if the number of available replicas for the involved chunks on the controller is less than the configured *dfsReplicationFactor*, this error is thrown.

## Solutions {#solutions .section}

-   Execute `getClusterChunksStatus` to check if the number of replicas for the partition matches the expected value.

-   Execute `getAllChunks` to check if there are missing replicas.

-   Troubleshoot if any nodes are offline or if any nodes did not reported with the logs, or executing `getClusterChunksStatus` and `getAllChunks`.

-   Set *forceDelete*=true to ignore the number of available replicas and forcibly delete the partition. Note this operation will result in residual data remaining on the offline replicas not deleted.


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

