# S01008 {#s01008}

## Error Code {#error_code .section}

S01008

## Error Message {#error_message .section}

`The source and target replicas of chunk <chunkId> for recovery are not available. The system will retry later. RefId:S01008`

## Probable Causes {#probable_causes .section}

Chunk recovery involves a source node and a target node. The target node is the node being recovered. Chunk recovery requires the chunk version in the source node matches that in the meta data of the controller. This error is thrown if no available source and target node can be found. Specifically, the causes can be:

-   The target node is offline when the recovery task is to be executed.
-   The chunk only has one replica on the target node, and other nodes hosting replicas are not online.
-   Except for the target node, the versions of the replicas on other nodes are inconsistent with the controller.

## Solutions {#solutions .section}

Execute `getClusterChunksStatus` on the controller to view the status of each chunk replica for further troubleshooting.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

