# S01004 {#s01004}

## Error Code {#error_code .section}

S01004

## Error Message {#error_message .section}

`<WARNING> openChunks attempted to colocate chunk <xxx> with sibling chunks but failed. The replicas for sibling chunks are expected to be <xxx>, but found <xxx>. RefId:S01004`

## Probable Causes {#probable_causes .section}

When a new chunk is added, the system first determines which nodes to place the replicas of the new chunk on. The nodes where other chunks of the same partition reside will first be selected, ensuring that all chunks of a partition can be distributed on the same nodes as much as possible. Therefore, when executing distributed SQL queries, data of a partition can be retrieved from the same node.

If the number of nodes found for other chunks of the same partition is less than the number of replicas required, this warning is reported.

Specifically, when adding a new chunk, if there is another table under the same partition, but the replicas of the table chunks are not all online, this warning is triggered.

For example, table pt1 has data in the 20230101 partition with its replicas distributed on node1 and node2, and node2 is currently offline. If another table pt2 writes data to the 20230101 partition, and attempts to add a new chunk, the system reports that only one replica of its sibling chunks is online, and throws this message: `openChunks attempted to colocate chunk <xxx> with sibling chunks but failed. The replicas for sibling chunks are expected to be 2, but found 1. RefId:S01004`

## Solutions {#solutions .section}

Check if any node is offline when this warning occurs.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

