# S01003 {#s01003}

## Error Code {#error_code .section}

S01003

## Error Message {#error_message .section}

`deleteSubChunks failed on <path> because the chunk <chunkId> is not in COMPLETE state. RefId:S01003`

## Probable Causes {#probable_causes .section}

When a user deletes databases and tables, or the system cleans up stale chunks, a transaction will attempt to delete the corresponding chunks. If a chunk is found in building state and there is no pending recovery task, this error is thrown because the chunk cannot be deleted.

In the error message, *&lt;path&gt;* is the file path in the distributed file system, and *&lt;chunkId&gt;* is a GUID \(globally unique identifier\) of a partition.

## Solutions {#solutions .section}

-   Wait for the transaction involving the chunk to complete before deleting the database or table.

-   Revoke the background task that involves the transaction before deleting the database or table.


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

