# S01002 {#s01002}

## Error Code {#error_code .section}

S01002

## Error Message {#error_message .section}

`The new partition ranges specified in newRanges cannot overlap with the existing partition ranges. RefId: S01002`

## Probable Causes {#probable_causes .section}

When using the function `addRangePartitions` to add new partitions to a partitioned database with RANGE domain, the partition range specified in *newRanges*overlap with the current partitions in the database.

For example:

``` {#codeblock_i2j_kkn_1bc}
db=database(directory="dfs://rangedb", partitionType=RANGE, partitionScheme=0 50 100)
addRangePartitions(dbhandle=db, newRanges=50 100 150 200)
```

The partition range 50-100 overlaps with the existing partitions.

## Solutions {#solutions .section}

Remove the overlapping ranges from *newRanges* and try again. You can check the current partitioning scheme using the `schema` function:

``` {#codeblock_cdf_lkn_1bc}
schema(database(directory="dfs://rangedb"))
// Returns partitionSchema->[0,50,100]
addRangePartitions(dbhandle=db, newRanges=100 150 200) 
// Returns 2, meaning 2 partitions have been added
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

