# S00008 {#s00008}

## Error Code {#error_code .section}

S00008

## Error Message {#error_message .section}

-   `<ERROR> Couldn't open file [{msg file path}]. {error message}. RefId:S00008`

-   `<ERROR> Couldn't open file [{obj file path}]. {error message}. RefId:S00008`


## Probable Causes {#probable_causes .section}

The logs and results of the job submitted by the function `submitJob` will be persisted to a *.msg* file \(`batchJobDir + "/" + jobId + ".msg"`\) and an *.obj* file \(`batchJobDir + "/" + jobId + ".obj"`\). *batchJobDir* is the path specified by the *batchJobDir* configuration parameter \(*&lt;HomeDir&gt;/batchJobs* by default\).

When the system fails to open these two files, it logs the error. Thereafter, any further outputs will be ignored and will not be persisted to the two files.

Common causes for this error include:

1.  Insufficient permissions. For details about the cause, see [fopen\(3\) - Linux manual page \(man7.org\)](https://www.man7.org/linux/man-pages/man3/fopen.3.html).

2.  The file has been memory-mapped by another process.For details about the cause, see [fcntl\(2\) - Linux manual page](https://www.man7.org/linux/man-pages/man2/fcntl.2.html).


## Solutions {#solutions .section}

Figure out the causes based on the error message and troubleshoot the issue \(such as checking for permissions on the relevant path\).

The \{error messages\} above are standard errors of the operating system. For more information, see:

-   Linux:

    -   [strerror\(3\) - Linux manual page \(man7.org\)](https://www.man7.org/linux/man-pages/man3/strerror.3.html)

    -   [errno\(3\) - Linux manual page \(man7.org\)](https://www.man7.org/linux/man-pages/man3/errno.3.html)

-   Windows:

    -   [FormatMessage function \(winbase.h\) - Win32 apps \| Microsoft Learn](https://learn.microsoft.com/en-us/windows/win32/api/winbase/nf-winbase-formatmessage)

    -   [WSAGetLastError function \(winsock.h\) - Win32 apps \| Microsoft Learn](https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-wsagetlasterror)


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

