# S00006 {#s00006}

## Error Code {#error_code .section}

S00006

## Error Message {#error_message .section}

`Maximum connections <num> reached. Close unused connections or increase maxConnections limit. RefId:S00006`

## Probable Causes {#probable_causes .section}

The number of connections between clients and the server is increased by one when a socket is created and the number of connections has not reached the *maxConnections* limit; it is decreased by one when a connection is closed by the protocol state machine. This error occurs when the number of connections exceeds the configuration parameter *maxConnections*.

Probable causes for this error include:

-   An excessive number of connections to the server.

-   An excessively small *maxConnections*.


## Solutions {#solutions .section}

1.  Close unnecessary connections.

2.  Set a higher *maxConnections*.


For more information on configuration parameters, please see [Reference](../../Database/Configuration/reference.md).

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

