/*
 * Demo.cpp
 *
 *  Created on: Apr 19, 2017
 *      Author: dzhou
 */

#include "hex2Base64.h"
#include <vector>
#include <string>

using namespace ddb;

// Base64编码表
static const std::string K_BASE64_CHARS = 
             "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
             "abcdefghijklmnopqrstuvwxyz"
             "0123456789+/";

// 将16进制字符转换为对应的数值
unsigned char hexCharToValue(unsigned char c) {
    if (c >= '0' && c <= '9') return c - '0';
    if (c >= 'a' && c <= 'f') return c - 'a' + 10;
    if (c >= 'A' && c <= 'F') return c - 'A' + 10;
    return 0; // 非法字符处理
}

// 将16进制字符串转换为字节数组
std::vector<unsigned char> hexToBytes(const std::string& hexStr) {
    std::vector<unsigned char> bytes;
    for (size_t i = 0; i < hexStr.length(); i += 2) {
        unsigned char high = hexCharToValue(hexStr[i]);
        unsigned char low = hexCharToValue(hexStr[i+1]);
        bytes.push_back((high << 4) | low);
    }
    return bytes;
}

// 将字节数组转换为Base64字符串
std::string bytesToBase64(const std::vector<unsigned char>& bytes) {
    std::string base64;
    int i = 0;
    int j = 0;
    unsigned char charArray3[3];
    unsigned char charArray4[4];
    
    for (auto byte : bytes) {
        charArray3[i++] = byte;
        if (i == 3) {
            charArray4[0] = (charArray3[0] & 0xfc) >> 2;
            charArray4[1] = ((charArray3[0] & 0x03) << 4) + ((charArray3[1] & 0xf0) >> 4);
            charArray4[2] = ((charArray3[1] & 0x0f) << 2) + ((charArray3[2] & 0xc0) >> 6);
            charArray4[3] = charArray3[2] & 0x3f;
            
            for (i = 0; i < 4; i++) {
                base64 += K_BASE64_CHARS[charArray4[i]];
            }
            i = 0;
        }
    }
    
    if (i) {
        for (j = i; j < 3; j++) {
            charArray3[j] = '\0';
        }
        
        charArray4[0] = (charArray3[0] & 0xfc) >> 2;
        charArray4[1] = ((charArray3[0] & 0x03) << 4) + ((charArray3[1] & 0xf0) >> 4);
        charArray4[2] = ((charArray3[1] & 0x0f) << 2) + ((charArray3[2] & 0xc0) >> 6);
        charArray4[3] = charArray3[2] & 0x3f;
        
        for (j = 0; j < i + 1; j++) {
            base64 += K_BASE64_CHARS[charArray4[j]];
        }
        
        while (i++ < 3) {
            base64 += '=';
        }
    }
    
    return base64;
}

ConstantSP encode(Heap* heap, const ConstantSP& a, const ConstantSP& b)
{
	std::ignore = heap;
    std::ignore = b;
    std::string hexStr = a->getString();
    // std::cout << "原始16进制字符串: " << hexStr << std::endl;
    // 将16进制字符串转换为字节数组
    std::vector<unsigned char> bytes = hexToBytes(hexStr);
    
    // 将字节数组转换为Base64字符串
    std::string base64Str = bytesToBase64(bytes);
    
    // std::cout << "Base64编码结果: " << base64Str << std::endl;
	return new String(base64Str);
}
