#pragma once

#include "CoreConcept.h"

class DDBConnection {
    ddb::SessionSP session_;
    string host_;
    int port_;
    string username_;
    string passwd_;
    ddb::ConstantSP conn_;

public:
    DDBConnection(const string &host, const int &port, const string &username, const string &passwd);
    DDBConnection(ddb::SessionSP session, const string &host, const int &port, const string &username, const string &passwd);
    virtual ~DDBConnection();
    ddb::ConstantSP run(const string &script);
    ddb::ConstantSP run(const string &functionName, const ddb::vector<ddb::ConstantSP> &arguments);
    ddb::ConstantSP upload(const string &name, const ddb::ConstantSP &value);
    ddb::ConstantSP subscribe(const string &tableName, const string &actionName, int offset, ddb::ConstantSP handler, int batchSize, int throttle);
    ddb::ConstantSP unsubscribe(const string &tableName, const string &actionName);
    void close();
};