#include "BacktestWrapper.h"
#include "CoreConcept.h"
#include "DDBConnection.h"

class CryptoBacktest {
    ddb::SmartPointer<DDBConnection> conn_;

  public:
    CryptoBacktest(ddb::SmartPointer<DDBConnection> conn);
    SmartPointer<BacktestWrapper> runCryptoBacktest(ddb::ConstantSP strategyName, ddb::DictionarySP userConfig,
                                                    ddb::DictionarySP eventCallbacks);
    static ddb::DictionarySP getUnifiedConfig(ddb::ConstantSP startDate, ddb::ConstantSP endDate,
                                              ddb::ConstantSP dataType);

  private:
    ddb::TableSP getCryptoFundingRate(ddb::VectorSP codes, ddb::ConstantSP begt, ddb::ConstantSP endt);
    ddb::TableSP getBinanceMinKLine(ddb::VectorSP codes, ddb::ConstantSP begt, ddb::ConstantSP endt,
                                    ddb::ConstantSP futuresOrSpot);
    ddb::TableSP getCryptoSecurityReference(ddb::TableSP data);
    ddb::TableSP getCryptoSecurityReferenceFromDepth(ddb::VectorSP codes, ddb::ConstantSP begt, ddb::ConstantSP endt);
    ddb::TableSP getSnapshotData(ddb::VectorSP codes, ddb::ConstantSP begt, ddb::ConstantSP endt);
};