#include "BacktestWrapper.h"

#include "CoreConcept.h"
#include "Swordfish.h"

BacktestWrapper::BacktestWrapper(ConstantSP name, DictionarySP config, DictionarySP eventCallbacks, ConstantSP jit,
                                 TableSP securityReference)
    : DDBPlugin(PLUGIN_NAME),
      name_(name),
      config_(config),
      eventCallbacks_(eventCallbacks),
      jit_(jit),
      securityReference_(securityReference) {
    vector<ConstantSP> args = {name, config, eventCallbacks, jit, securityReference};
    engine_ = this->callFunction("createBacktester", args);
}

BacktestWrapper::BacktestWrapper(ConstantSP name) : DDBPlugin(PLUGIN_NAME) {
    name_ = name;
    engine_ = DolphinDBLib::execute("getStreamEngine('" + name->getString() + "')");
}

SmartPointer<BacktestWrapper> BacktestWrapper::createBacktester(ConstantSP name, DictionarySP config,
                                                                DictionarySP eventCallbacks, ConstantSP jit,
                                                                TableSP securityReference) {
    return SmartPointer<BacktestWrapper>(new BacktestWrapper(name, config, eventCallbacks, jit, securityReference));
}

ConstantSP BacktestWrapper::appendQuotationMsg(TableSP msg) {
    std::vector<ConstantSP> arguments = {engine_, msg};
    auto res = this->callFunction("appendQuotationMsg", arguments);
    return res;
}

ConstantSP BacktestWrapper::appendQuotationMsg(ConstantSP engine, TableSP msg) {
    std::vector<ConstantSP> arguments = {engine, msg};
    auto res = DolphinDBLib::execute("Backtest::appendQuotationMsg", arguments);
    return res;
}

ConstantSP BacktestWrapper::setUniverse(VectorSP symbolList) {
    std::vector<ConstantSP> arguments = {engine_, symbolList};
    auto res = this->callFunction("setUniverse", arguments);
    return res;
}

ConstantSP BacktestWrapper::setUniverse(ConstantSP engine, VectorSP symbolList) {
    std::vector<ConstantSP> arguments = {engine, symbolList};
    auto res = DolphinDBLib::execute("Backtest::setUniverse", arguments);
    return res;
}

ConstantSP BacktestWrapper::submitOrder(ConstantSP msg, ConstantSP label, ConstantSP orderType,
                                        ConstantSP accountType) {
    std::vector<ConstantSP> arguments = {engine_, msg, label, orderType, accountType};
    auto res = this->callFunction("submitOrder", arguments);
    return res;
}

ConstantSP BacktestWrapper::submitOrder(ConstantSP engine, ConstantSP msg, ConstantSP label, ConstantSP orderType,
                                        ConstantSP accountType) {
    std::vector<ConstantSP> arguments = {engine, msg, label, orderType, accountType};
    auto res = DolphinDBLib::execute("Backtest::submitOrder", arguments);
    return res;
}

ConstantSP BacktestWrapper::getPosition(ConstantSP symbol, ConstantSP accountType) {
    std::vector<ConstantSP> arguments = {engine_, symbol, accountType};
    auto res = this->callFunction("getPosition", arguments);
    return res;
}

ConstantSP BacktestWrapper::getPosition(ConstantSP engine, ConstantSP symbol, ConstantSP accountType) {
    std::vector<ConstantSP> arguments = {engine, symbol, accountType};
    auto res = DolphinDBLib::execute("Backtest::getPosition", arguments);
    return res;
}

ConstantSP BacktestWrapper::getDailyPosition(ConstantSP symbol, ConstantSP accountType) {
    std::vector<ConstantSP> arguments = {engine_, symbol, accountType};
    auto res = this->callFunction("getDailyPosition", arguments);
    return res;
}

ConstantSP BacktestWrapper::getDailyPosition(ConstantSP engine, ConstantSP symbol, ConstantSP accountType) {
    std::vector<ConstantSP> arguments = {engine, symbol, accountType};
    auto res = DolphinDBLib::execute("Backtest::getDailyPosition", arguments);
    return res;
}

ConstantSP BacktestWrapper::getTradeDetails() {
    std::vector<ConstantSP> arguments = {engine_};
    auto res = this->callFunction("getTradeDetails", arguments);
    return res;
}

ConstantSP BacktestWrapper::cancelOrder(ConstantSP symbol) {
    std::vector<ConstantSP> arguments = {engine_, symbol};
    auto res = this->callFunction("cancelOrder", arguments);
    return res;
}

ConstantSP BacktestWrapper::cancelOrder(ConstantSP engine, ConstantSP symbol) {
    std::vector<ConstantSP> arguments = {engine, symbol};
    auto res = DolphinDBLib::execute("Backtest::cancelOrder", arguments);
    return res;
}

ConstantSP BacktestWrapper::getOpenOrders(ConstantSP symbol, ConstantSP orders, ConstantSP label, ConstantSP accountType) {
    std::vector<ConstantSP> arguments = {engine_, symbol, orders, label, accountType};
    auto res = this->callFunction("getOpenOrders", arguments);
    return res;
}

ConstantSP BacktestWrapper::getOpenOrders(ConstantSP engine, ConstantSP symbol, ConstantSP orders, ConstantSP label, ConstantSP accountType) {
    std::vector<ConstantSP> arguments = {engine, symbol, orders, label, accountType};
    auto res = DolphinDBLib::execute("Backtest::getOpenOrders", arguments);
    return res;
}

ConstantSP BacktestWrapper::getTradeDetails(ConstantSP engine) {
    std::vector<ConstantSP> arguments = {engine};
    auto res = DolphinDBLib::execute("Backtest::getTradeDetails", arguments);
    return res;
}

void BacktestWrapper::dropBacktestEngine() {
    std::vector<ConstantSP> arguments = {engine_};
    this->callFunction("dropBacktestEngine", arguments);
}