from binance.websocket.um_futures.websocket_client import UMFuturesWebsocketClient
from binance.um_futures import UMFutures
import time, threading

PROXY = 'http://127.0.0.1:7890'
# 1. Create listenKey
client = UMFutures(key='xxxxxx', secret='xxxxxx',proxies={'http': PROXY, 'https': PROXY})
response = client.new_listen_key()
listen_key = response['listenKey']
print(f"Listen Key: {listen_key}")

# 2. Subscribe to User Data Stream
def message_handler(_, message):
    print(f"Receive message: {message}")
    import json
    msg = json.loads(message)
    
    # Account update (balance + positions)
    if msg.get('e') == 'ACCOUNT_UPDATE':
        update = msg.get('a', {})
        
        # Balance update
        for balance in update.get('B', []):
            print(f"Balance: {balance['a']} - Wallet balance={balance['wb']}, Available balance={balance['cw']}")
        
        # Position update
        for position in update.get('P', []):
            if float(position['pa']) != 0:
                print(f"Position: {position['s']} - Quantity={position['pa']}, Average open price={position['ep']}")
    
    # Order update
    elif msg.get('e') == 'ORDER_TRADE_UPDATE':
        order = msg.get('o', {})
        print(f"Order: {order['s']} - {order['X']} - {order['x']}")

ws_client = UMFuturesWebsocketClient(on_message=message_handler,proxies={'http': PROXY, 'https': PROXY})
ws_client.user_data(listen_key=listen_key)

# 3. Periodic renewal
def keep_alive():
    while True:
        time.sleep(30 * 60)
        try:
            client.renew_listen_key()
            print(f"[{time.strftime('%H:%M:%S')}] listenKey renewal succeeded")
        except Exception as e:
            print(f"listenKey renewal failed: {e}")

threading.Thread(target=keep_alive, daemon=True).start()

# Keep running
try:
    while True:
        time.sleep(1)
except KeyboardInterrupt:
    ws_client.stop()